% Main file for the II estimation of the OU model under measurement error.

clear;

clc;


%% True structural parameters

mu=0.1;

kappa=0.05;

sigma_e=0.02;

sigma_u=0.0447;

params=[mu,sigma_e,kappa]; % parameters of the OU model

%% Setup parameters

T=1000;

H=500;

M=1000;

%% Preallocation of the output matrices with the parameters
theta_hat=zeros(4,M); % with noise

theta_hat_NC=zeros(3,M); % no-noise

theta_hat_signal=zeros(3,M); % no-noise on the true signal

chi2_hat=zeros(M,1); % value of the criterion function

chi2_hat_NC=zeros(M,1); % value of the criterion function

chi2_hat_signal=zeros(M,1); % value of the criterion function

my_optim = optimset('Display','iter', 'Algorithm','interior-point','TolFun',...
    10^-6,'TolX',10^-6,'DiffMin',10^-6,'MaxFunEvals', 1000);

for i=1:M;

randn('seed',1+i);

w1=randn(T,2); % innovations for the OU model

y=simulate_OU_exact(params,w1(:,1));
     
 u=w1(:,2)*sigma_u; % measurement error
        
 x=y+u; % contaminated process (signal + ME)

%% On contaminated data

beta_hat=crude_discretrization_OLS(x); % auxiliary on the contaminated data
%% On signal

beta_hat_signal=crude_discretrization_OLS(y); % auxiliary on the signal

%% Indirect inference
randn('seed',1020*i);

W=randn(T,2,H); % generate big matrix with innovations used in II

par0 = [-2.2;-4;-3;-3]; % transform parameters (log()) to guarantee non-negativity

[a,chi2_hat(i),ex_a]    = fminunc('indirect_inference_OU_crude_noise', par0, my_optim, beta_hat, W);

[b,chi2_hat_NC(i),ex_b] = fminunc('indirect_inference_OU_crude_no_noise', par0(1:3), my_optim, beta_hat(1:3), W);

[c,chi2_hat_signal(i),ex_d] = fminunc('indirect_inference_OU_crude_no_noise', par0(1:3), my_optim, beta_hat_signal(1:3), W);

theta_hat(:,i)=[exp(a')];

theta_hat_NC(:,i)=exp(b');

theta_hat_signal(:,i)=[exp(c')];

end;
